﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RimWorld;
using Verse;

namespace Ageinator
{
    public class Projectile_AgeinatorBulletLite : Bullet
    {
        #region Properties
        //
        public ThingDef_AgeinatorBulletLite Def
        {
            get
            {
                return this.def as ThingDef_AgeinatorBulletLite;
            }
        }
        #endregion Properties

        #region Overrides
        protected override void Impact(Thing hitThing)
        {
            base.Impact(hitThing);


            /*
             * Null checking is very important in RimWorld.
             * 99% of errors reported are from NullReferenceExceptions (NREs).
             * Make sure your code checks if things actually exist, before they
             * try to use the code that belongs to said things.
             */
            if (Def != null && hitThing != null && hitThing is Pawn hitPawn) //Fancy way to declare a variable inside an if statement. - Thanks Erdelf.
            {
                var rand = Rand.Value; // This is a random percentage between 0% and 100%
                if (rand <= Def.AddHediffChance) // If the percentage falls under the chance, success!
                {
                    /*
                     * Messages.Message flashes a message on the top of the screen. 
                     * You may be familiar with this one when a colonist dies, because
                     * it makes a negative sound and mentioneds "So and so has died of _____".
                     * 
                     * Here, we're using the "Translate" function. More on that later in
                     * the localization section.
                     */
                    Messages.Message("AgeinatorBulletLite_SuccessMessage".Translate(new object[] {
                        this.launcher.Label, hitPawn.Label
                    }), MessageSound.Standard);

                   
                    hitPawn.ageTracker.AgeBiologicalTicks += 36000000;

                    if (hitPawn.ageTracker.AgeBiologicalTicks >= 288000000)
                    {
                        Hediff hediff = HediffMaker.MakeHediff(Def.HediffToAdd, hitPawn, null);
                        hitPawn.health.AddHediff(hediff, null, null);
                    }

                    if (hitPawn.ageTracker.AgeBiologicalTicks >= 324000000)
                    {
                        var FrailOnPawn = hitPawn?.health?.hediffSet?.GetFirstHediffOfDef(Def.HediffToAdd);
                        var randomSeverity = Rand.Range(0.15f, 0.30f);
                        FrailOnPawn.Severity += randomSeverity;

                        Hediff hediff = HediffMaker.MakeHediff(HediffDefOf.Cataract, hitPawn, null);
                        hitPawn.health.AddHediff(hediff, null, null);
                    }

                    if (hitPawn.ageTracker.AgeBiologicalTicks >= 360000000)
                    {
                        var FrailOnPawn = hitPawn?.health?.hediffSet?.GetFirstHediffOfDef(Def.HediffToAdd);
                        var randomSeverity = Rand.Range(0.15f, 0.30f);
                        FrailOnPawn.Severity += randomSeverity;

                        Hediff hediff = HediffMaker.MakeHediff(HediffDefOf.Malnutrition, hitPawn, null);
                        hitPawn.health.AddHediff(hediff, null, null);

                        Hediff hediff2 = HediffMaker.MakeHediff(HediffDefOf.Hypothermia, hitPawn, null);
                        hitPawn.health.AddHediff(hediff2, null, null);
                    }

                    if (hitPawn.ageTracker.AgeBiologicalTicks >= 396000000)
                    {
                        var FrailOnPawn = hitPawn?.health?.hediffSet?.GetFirstHediffOfDef(Def.HediffToAdd);
                        var randomSeverity = Rand.Range(0.15f, 0.30f);
                        FrailOnPawn.Severity += randomSeverity;

                        Hediff hediff2 = HediffMaker.MakeHediff(HediffDefOf.BloodLoss, hitPawn, null);
                        hitPawn.health.AddHediff(hediff2, null, null);

                    }


                }
                else //failure!
                {
                    /*
                     * Motes handle all the smaller visual effects in RimWorld.
                     * Dust plumes, symbol bubbles, and text messages floating next to characters.
                     * This mote makes a small text message next to the character.
                     */
                    MoteMaker.ThrowText(hitThing.PositionHeld.ToVector3(), hitThing.MapHeld, "AgeinatorBulletLite_FailureMote".Translate(Def.AddHediffChance), 12f);
                }
            }
        }
        #endregion Overrides
    }
}
